unit AnsiTo866;

//=============================================================================
//          .
//           DELPHI
//  (c)  ..  2.  11.10.2009.
//=============================================================================
//     INTERFACE
//=============================================================================
interface

// ----------------------------------------------------------------------------
//       Ansi 
procedure WriteRus (RqStr : string);

//       Ansi    
procedure WriteLnRus (RqStr : string);


//=============================================================================
//     IMPLEMENTATION
//=============================================================================

implementation
uses SysUtils;


//=============================================================================
//         Write WriteLn
//=============================================================================

//    Ansi  ( )  ACSII 866 
// ( )   11.10.2009.

const TabAnsiTo866 : array [0..255] of byte =
(
000, 001, 002, 003, 004, 005, 006, 007, 008, 009, 010, 011, 012, 013, 014, 015,
016, 017, 018, 019, 020, 021, 022, 023, 024, 025, 026, 027, 028, 029, 030, 031,
032, 033, 034, 035, 036, 037, 038, 039, 040, 041, 042, 043, 044, 045, 046, 047,
048, 049, 050, 051, 052, 053, 054, 055, 056, 057, 058, 059, 060, 061, 062, 063,
064, 065, 066, 067, 068, 069, 070, 071, 072, 073, 074, 075, 076, 077, 078, 079,
080, 081, 082, 083, 084, 085, 086, 087, 088, 089, 090, 091, 092, 093, 094, 095,
096, 097, 098, 099, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,

//  0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
//  128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
{8} 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,

//  144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
{9} 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,

//  160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
{A} 160, 161, 162, 163, 164, 131, 166, 167, 240, 169, 242, 171, 172, 173, 174, 244,

//  176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
{B} 176, 177, 073, 105, 163, 181, 182, 183, 241, 252, 243, 187, 188, 189, 190, 245,

//  192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
{C} 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,

//  208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
{D} 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,

//  224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
{E} 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,

//  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
{F} 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239
//  0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
);

// ----------------------------------------------------------------------------
//       Ansi 
procedure WriteRus (RqStr : string);
var Ind : word;
begin
 if Length(RqStr) > 0 then
 begin
   //             
   for Ind:=1 to Length(RqStr) do
   begin
     Write(Char(TabAnsiTo866[Ord(RqStr[Ind])]));
   end;
 end;
end;


// ----------------------------------------------------------------------------
//       Ansi    
procedure WriteLnRus (RqStr : string);
begin
 WriteRus(RqStr);
 WriteLn;
end;

// ----------------------------------------------------------------------------
end.
